//******************************************************************************
//
//	File:		InstantiateBCheckBox.h
//
//	Description:	Unarchiving a CheckBox instance.
//
//	Copyright 1996, International Lorienne Inc.
//
//******************************************************************************

#include "CheckBox.h"
#include "LRModule.h"
#include <string.h>

#pragma export on
BView* InstantiateBCheckBox(BMessage *message);
#pragma export off

BView* InstantiateBCheckBox(BMessage *message)
{
	BCheckBox	*instance;
	BRect		frame;
	char		*label;
	long		enabled;
	long		follow;
	float		value;
	rgb_color	color;
	
	// Default values
	
	frame.left = 10;
	frame.top = 10;
	frame.right = 90;
	frame.bottom = 30;
	label = strdup("Check:");
	enabled = 1;
	follow = B_FOLLOW_LEFT | B_FOLLOW_TOP;
	color.red = 210;
	color.green = 210;
	color.blue = 210;

	// Decode instance values
			
	if (message->HasPoint("Origin")) {						// Used when dropped
		BPoint origin = message->FindPoint("Origin");
		value = frame.Width();
		frame.left = origin.x;
		frame.right = frame.left + value;
		value = frame.Height();
		frame.top = origin.y;
		frame.bottom = frame.top + value;
	}	
	if (message->HasRect("Frame")) {
		frame = message->FindRect("Frame");
	}	
	if (message->HasString("Label")) {
		label = strdup(message->FindString("Label"));
	}	
	if (message->HasLong("Follow Mode")) {
		follow = message->FindLong("Follow Mode");
	}	
	if (message->HasBool("Enabled")) {
		enabled = message->FindBool("Enabled");
	}	
	if (message->HasData("View Color",B_RGB_COLOR_TYPE)) {
		long size;
		color = *((rgb_color *) message->FindData("View Color",B_RGB_COLOR_TYPE,&size));			// Color
	}	
	else {
		message->AddData("View Color",B_RGB_COLOR_TYPE,(const void *)(&color),sizeof(rgb_color));
	}	

	instance = new BCheckBox(frame,"BCheckBox",label,NULL,follow);

	instance->SetEnabled((bool)enabled);
	instance->SetViewColor(color);
	instance->SetLowColor(color);
	if (message->HasString("Font Name")) {
		instance->SetFontName(message->FindString("Font Name"));
	}	

	free(label);	

	return instance;
}